/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.bootstrap;

import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.minecraft.bootstrap.Downloader;
import net.minecraft.bootstrap.FatalBootstrapError;
import net.minecraft.bootstrap.Util;

public class Bootstrap
extends JFrame {
    private static final Font MONOSPACED = new Font("Monospaced", 0, 12);
    public static final String LAUNCHER_URL = "http://www.minecraft-moscow.ru/files/MinecraftMoscowLauncher.jar";
    private final File workDir;
    private final Proxy proxy;
    private final File launcherJar;
    private final File packedLauncherJarNew;
    private final JTextArea textArea;
    private final JScrollPane scrollPane;
    private final PasswordAuthentication proxyAuth;
    private final String[] remainderArgs;
    private final StringBuilder outputBuffer = new StringBuilder();

    public Bootstrap(File workDir, Proxy proxy, PasswordAuthentication proxyAuth, String[] remainderArgs) {
        super("Minecraft-Moscow Launcher");
        this.workDir = workDir;
        this.proxy = proxy;
        this.proxyAuth = proxyAuth;
        this.remainderArgs = remainderArgs;
        this.launcherJar = new File(workDir, "launcher.jar");
        this.packedLauncherJarNew = new File(workDir, "launcher.pack.lzma.new");
        this.setSize(854, 480);
        this.setDefaultCloseOperation(3);
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setEditable(false);
        this.textArea.setFont(MONOSPACED);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(1);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setBorder(null);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.add(this.scrollPane);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.println("Bootstrap (v6)");
        this.println("Current time is " + DateFormat.getDateTimeInstance(2, 2, Locale.US).format(new Date()));
        this.println("System.getProperty('os.name') == '" + System.getProperty("os.name") + "'");
        this.println("System.getProperty('os.version') == '" + System.getProperty("os.version") + "'");
        this.println("System.getProperty('os.arch') == '" + System.getProperty("os.arch") + "'");
        this.println("System.getProperty('java.version') == '" + System.getProperty("java.version") + "'");
        this.println("System.getProperty('java.vendor') == '" + System.getProperty("java.vendor") + "'");
        this.println("System.getProperty('sun.arch.data.model') == '" + System.getProperty("sun.arch.data.model") + "'");
        this.println("");
    }

    public void execute(boolean force) {
        if (this.packedLauncherJarNew.isFile()) {
            this.println("Found cached update");
            this.renameNew();
        }
        Downloader.Controller controller = new Downloader.Controller();
        if (force || !this.launcherJar.exists()) {
            Downloader downloader = new Downloader(controller, this, this.proxy, null, this.packedLauncherJarNew);
            downloader.run();
            if (controller.hasDownloadedLatch.getCount() != 0L) {
                throw new FatalBootstrapError("Unable to download while being forced");
            }
            this.renameNew();
        } else {
            String md5 = this.getMd5(this.launcherJar);
            Thread thread = new Thread(new Downloader(controller, this, this.proxy, md5, this.launcherJar));
            thread.setName("Launcher downloader");
            thread.start();
            try {
                this.println("Looking for update");
                boolean wasInTime = controller.foundUpdateLatch.await(3L, TimeUnit.SECONDS);
                if (controller.foundUpdate.get()) {
                    this.println("Found update in time, waiting to download");
                    controller.hasDownloadedLatch.await();
                    this.renameNew();
                } else if (!wasInTime) {
                    this.println("Didn't find an update in time.");
                }
            }
            catch (InterruptedException e) {
                throw new FatalBootstrapError("Got interrupted: " + e.toString());
            }
        }
        this.startLauncher(this.launcherJar);
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMd5(File file) {
        DigestInputStream stream = null;
        try {
            stream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance("MD5"));
            byte[] buffer = new byte[65536];
            int read = stream.read(buffer);
            while (read >= 1) {
                read = stream.read(buffer);
            }
            Bootstrap.closeSilently(stream);
        }
        catch (Exception ignored) {
            String string = null;
            return string;
        }
        finally {
            Bootstrap.closeSilently(stream);
        }
        return String.format("%1$032x", new BigInteger(1, stream.getMessageDigest().digest()));
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void print(String string) {
        System.out.print(string);
        this.outputBuffer.append(string);
        Document document = this.textArea.getDocument();
        final JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
        boolean shouldScroll = (double)scrollBar.getValue() + scrollBar.getSize().getHeight() + (double)(MONOSPACED.getSize() * 2) > (double)scrollBar.getMaximum();
        try {
            document.insertString(document.getLength(), string, null);
        }
        catch (BadLocationException ignored) {
            // empty catch block
        }
        if (shouldScroll) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    scrollBar.setValue(Integer.MAX_VALUE);
                }
            });
        }
    }

    public void startLauncher(File launcherJar) {
        this.println("Starting launcher.");
        try {
            Class<?> aClass = new URLClassLoader(new URL[]{launcherJar.toURI().toURL()}).loadClass("net.minecraft.launcher.Launcher");
            Constructor<?> constructor = aClass.getConstructor(JFrame.class, File.class, Proxy.class, PasswordAuthentication.class, String[].class, Integer.class);
            constructor.newInstance(this, this.workDir, this.proxy, this.proxyAuth, this.remainderArgs, 5);
        }
        catch (Exception e) {
            throw new FatalBootstrapError("Unable to start: " + e);
        }
    }

    public void renameNew() {
        if (this.launcherJar.exists() && !this.launcherJar.isFile() && !this.launcherJar.delete()) {
            throw new FatalBootstrapError("while renaming, target path: " + this.launcherJar.getAbsolutePath() + " is not a file and we failed to delete it");
        }
        if (this.packedLauncherJarNew.isFile()) {
            this.println("Renaming " + this.packedLauncherJarNew.getAbsolutePath() + " to " + this.launcherJar.getAbsolutePath());
            if (this.packedLauncherJarNew.renameTo(this.launcherJar)) {
                this.println("Renamed successfully.");
            } else {
                if (this.launcherJar.exists() && !this.launcherJar.canWrite()) {
                    throw new FatalBootstrapError("unable to rename: target" + this.launcherJar.getAbsolutePath() + " not writable");
                }
                this.println("Unable to rename - could be on another filesystem, trying copy & delete.");
                if (this.packedLauncherJarNew.exists() && this.packedLauncherJarNew.isFile()) {
                    try {
                        Bootstrap.copyFile(this.packedLauncherJarNew, this.launcherJar);
                        if (this.packedLauncherJarNew.delete()) {
                            this.println("Copy & delete succeeded.");
                        }
                        this.println("Unable to remove " + this.packedLauncherJarNew.getAbsolutePath() + " after copy.");
                    }
                    catch (IOException e) {
                        throw new FatalBootstrapError("unable to copy:" + e);
                    }
                } else {
                    this.println("Nevermind... file vanished?");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File target) throws IOException {
        if (!target.exists()) {
            target.createNewFile();
        }
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel targetChannel = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            targetChannel = new FileOutputStream(target).getChannel();
            ((FileChannel)targetChannel).transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (targetChannel != null) {
                targetChannel.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        File workingDirectory;
        OptionSet optionSet;
        System.setProperty("java.net.preferIPv4Stack", "true");
        OptionParser optionParser = new OptionParser();
        optionParser.allowsUnrecognizedOptions();
        optionParser.accepts("help", "Show help").forHelp();
        optionParser.accepts("force", "Force updating");
        ArgumentAcceptingOptionSpec<String> proxyHostOption = optionParser.accepts("proxyHost", "Optional").withRequiredArg();
        ArgumentAcceptingOptionSpec<Integer> proxyPortOption = optionParser.accepts("proxyPort", "Optional").withRequiredArg().defaultsTo("8080", (String[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec<String> proxyUserOption = optionParser.accepts("proxyUser", "Optional").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> proxyPassOption = optionParser.accepts("proxyPass", "Optional").withRequiredArg();
        ArgumentAcceptingOptionSpec<File> workingDirectoryOption = optionParser.accepts("workDir", "Optional").withRequiredArg().ofType(File.class).defaultsTo(Util.getWorkingDirectory(), (File[])new File[0]);
        NonOptionArgumentSpec<String> nonOptions = optionParser.nonOptions();
        try {
            optionSet = optionParser.parse(args);
        }
        catch (OptionException e) {
            optionParser.printHelpOn(System.out);
            System.out.println("(to pass in arguments to minecraft directly use: '--' followed by your arguments");
            return;
        }
        if (optionSet.has("help")) {
            optionParser.printHelpOn(System.out);
            return;
        }
        String hostName = optionSet.valueOf(proxyHostOption);
        Proxy proxy = Proxy.NO_PROXY;
        if (hostName != null) {
            try {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hostName, (int)optionSet.valueOf(proxyPortOption)));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        String proxyUser = optionSet.valueOf(proxyUserOption);
        String proxyPass = optionSet.valueOf(proxyPassOption);
        PasswordAuthentication passwordAuthentication = null;
        if (!proxy.equals(Proxy.NO_PROXY) && Bootstrap.stringHasValue(proxyUser) && Bootstrap.stringHasValue(proxyPass)) {
            final PasswordAuthentication auth = passwordAuthentication = new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return auth;
                }
            });
        }
        if ((workingDirectory = optionSet.valueOf(workingDirectoryOption)).exists() && !workingDirectory.isDirectory()) {
            throw new FatalBootstrapError("Invalid working directory: " + workingDirectory);
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new FatalBootstrapError("Unable to create directory: " + workingDirectory);
        }
        List<String> strings = optionSet.valuesOf(nonOptions);
        String[] remainderArgs = strings.toArray(new String[strings.size()]);
        boolean force = optionSet.has("force");
        Bootstrap frame = new Bootstrap(workingDirectory, proxy, passwordAuthentication, remainderArgs);
        try {
            frame.execute(force);
        }
        catch (Throwable t) {
            ByteArrayOutputStream stracktrace = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(stracktrace));
            StringBuilder report = new StringBuilder();
            report.append(stracktrace).append("\n\n-- Head --\nStacktrace:\n").append(stracktrace).append("\n\n").append((CharSequence)frame.outputBuffer);
            report.append("\tMinecraft.Bootstrap Version: 6");
            frame.println("FATAL ERROR: " + stracktrace.toString());
            frame.println("\nPlease fix the error and restart.");
        }
    }

    public static boolean stringHasValue(String string) {
        return string != null && !string.isEmpty();
    }
}

