/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.minecraft.Launcher;
import net.minecraft.LoginForm;
import net.minecraft.MinecraftLauncher;
import net.minecraft.Util;

public class LauncherFrame
extends Frame {
    private static final long serialVersionUID = 1L;
    public Map<String, String> customParameters = new HashMap<String, String>();
    public Launcher launcher;
    public LoginForm loginForm;
    private static String[] args;
    private String username;
    private String password;

    public LauncherFrame() {
        super("\u041b\u0430\u0443\u043d\u0447\u0435\u0440 Minecraft-Moscow");
        this.setBackground(Color.BLACK);
        this.loginForm = new LoginForm(this);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.loginForm, "Center");
        p.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        this.add((Component)p, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        try {
            this.setIconImage(ImageIO.read(LauncherFrame.class.getResource("favicon.png")));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        System.out.println("FORCING EXIT!");
                        System.exit(0);
                    }
                }.start();
                if (LauncherFrame.this.launcher != null) {
                    LauncherFrame.this.launcher.stop();
                    LauncherFrame.this.launcher.destroy();
                }
                System.exit(0);
            }
        });
    }

    public void playCached(String userName) {
        try {
            if (userName == null || userName.length() <= 0) {
                userName = "Player";
            }
            this.launcher = new Launcher();
            this.launcher.customParameters.putAll(this.customParameters);
            this.launcher.customParameters.put("userName", userName);
            this.launcher.init();
            this.removeAll();
            this.add((Component)this.launcher, "Center");
            this.validate();
            this.launcher.start();
            this.loginForm = null;
            this.setTitle("Minecraft");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError(e.toString());
        }
    }

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("md5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public void login(String userName, String password) {
        this.username = userName;
        this.password = password;
        try {
            String parameters = "user=" + URLEncoder.encode(userName, "UTF-8") + "&password=" + URLEncoder.encode(password, "UTF-8") + "&version=" + 16 + "&hash=" + LauncherFrame.MD5(InetAddress.getLocalHost().getHostName() + System.getProperty("user.name"));
            String result = Util.excutePost("http://www.minecraft-moscow.ru/prox/auth/auth.php", parameters);
            if (result == null) {
                this.showError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443!");
                this.loginForm.setNoNetwork();
                return;
            }
            if (!result.contains(":")) {
                if (result.trim().equals("Bad login")) {
                    this.showError("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043b\u043e\u0433\u0438\u043d \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c!");
                } else if (result.trim().equals("Old version")) {
                    this.loginForm.setOutdated();
                    this.showError("\u041d\u0443\u0436\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043b\u0430\u0443\u043d\u0447\u0435\u0440!");
                } else {
                    this.showError(result);
                }
                this.loginForm.setNoNetwork();
                return;
            }
            String[] values = result.split(":");
            this.launcher = new Launcher();
            this.launcher.customParameters.putAll(this.customParameters);
            this.launcher.customParameters.put("userName", values[2].trim());
            this.launcher.customParameters.put("latestVersion", values[0].trim());
            this.launcher.customParameters.put("downloadTicket", values[1].trim());
            this.launcher.customParameters.put("sessionId", values[3].trim());
            this.launcher.init();
            this.removeAll();
            this.add((Component)this.launcher, "Center");
            this.validate();
            this.launcher.start();
            this.loginForm.loginOk();
            this.loginForm = null;
            this.setTitle("Minecraft");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError(e.toString());
            this.loginForm.setNoNetwork();
        }
    }

    private void showError(String error) {
        this.removeAll();
        this.add(this.loginForm);
        this.loginForm.setError(error);
        this.validate();
    }

    public boolean canPlayOffline(String userName) {
        Launcher launcher = new Launcher();
        launcher.customParameters.putAll(this.customParameters);
        launcher.init(userName, null, null, null);
        return launcher.canPlayOffline();
    }

    public static void main(String[] args) {
        LauncherFrame.args = args;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception localException) {
            // empty catch block
        }
        LauncherFrame launcherFrame = new LauncherFrame();
        launcherFrame.setVisible(true);
        launcherFrame.customParameters.put("stand-alone", "true");
        if (args.length >= 3) {
            String ip = args[2];
            String port = "25565";
            if (ip.contains(":")) {
                String[] parts = ip.split(":");
                ip = parts[0];
                port = parts[1];
            }
            launcherFrame.customParameters.put("server", ip);
            launcherFrame.customParameters.put("port", port);
        }
        if (args.length >= 1) {
            launcherFrame.loginForm.userName.setText(args[0]);
            if (args.length >= 2) {
                launcherFrame.loginForm.password.setText(args[1]);
                launcherFrame.loginForm.doLogin();
            }
        }
    }

    public void updateLauncher() {
        try {
            int len;
            String pathToJar = MinecraftLauncher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            String ext = pathToJar.substring(pathToJar.lastIndexOf(46) + 1);
            JOptionPane.showMessageDialog(this.launcher, "\u0412\u0430\u0448 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0443\u0441\u0442\u0430\u0440\u0435\u043b. \n\u0427\u0442\u043e\u0431\u044b \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439, \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u041e\u041a.");
            URL launcherURL = new URL("http://www.minecraft-moscow.ru/files/Launcher." + ext);
            InputStream is = launcherURL.openStream();
            FileOutputStream fos = new FileOutputStream(pathToJar);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            is.close();
            fos.close();
            JOptionPane.showMessageDialog(this.launcher, "\u041d\u043e\u0432\u044b\u0439 \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d. \n\u041f\u043e\u0441\u043b\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438\u0433\u0440\u0430 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438.");
            ArrayList<String> params = new ArrayList<String>();
            if ("exe".equalsIgnoreCase(ext)) {
                params.add(pathToJar);
            } else {
                params.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
                params.add("-Dsun.java2d.noddraw=true");
                params.add("-Dsun.java2d.d3d=false");
                params.add("-Dsun.java2d.opengl=false");
                params.add("-Dsun.java2d.pmoffscreen=false");
                params.add("-classpath");
                params.add(pathToJar);
                params.add("net.minecraft.LauncherFrame");
            }
            params.add(this.username);
            params.add(this.password);
            ProcessBuilder pb = new ProcessBuilder(params);
            Process process = pb.start();
            if (process == null) {
                throw new Exception("!");
            }
            System.exit(0);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter ps = new PrintWriter(sw);
            e.printStackTrace(ps);
            JOptionPane.showMessageDialog(this.launcher, sw.toString());
        }
    }
}

