/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.applet.Applet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.Constants;
import net.minecraft.Launcher;
import net.minecraft.Util;

public class GameUpdater
implements Runnable,
Constants {
    public static final int STATE_INIT = 1;
    public static final int STATE_DETERMINING_PACKAGES = 2;
    public static final int STATE_CHECKING_CACHE = 3;
    public static final int STATE_DOWNLOADING = 4;
    public static final int STATE_EXTRACTING_PACKAGES = 5;
    public static final int STATE_UPDATING_CLASSPATH = 6;
    public static final int STATE_SWITCHING_APPLET = 7;
    public static final int STATE_INITIALIZE_REAL_APPLET = 8;
    public static final int STATE_START_REAL_APPLET = 9;
    public static final int STATE_DONE = 10;
    public static final int STATE_GENERATING_MD5S = 11;
    public boolean oldLauncher = false;
    public int percentage;
    public int subPercentage;
    public int currentSizeExtract;
    public int totalSizeExtract;
    protected URL[] urlList;
    protected String[] md5s;
    protected String[] relativeUrls;
    protected int[] fileSizes;
    private static ClassLoader classLoader;
    protected Thread loaderThread;
    protected Thread animationThread;
    public boolean fatalError;
    public String fatalErrorDescription;
    protected String subtaskMessage = "";
    protected int state = 1;
    protected String[] genericErrorMessage = new String[]{"An error occured while loading the applet.", "Please contact support to resolve this issue.", "<placeholder for error message>"};
    protected boolean certificateRefused;
    protected String[] certificateRefusedMessage = new String[]{"Permissions for Applet Refused.", "Please accept the permissions dialog to allow", "the applet to continue the loading process."};
    protected static boolean natives_loaded;
    public static boolean forceUpdate;
    private String latestVersion;
    private String mainGameUrl;
    public boolean pauseAskUpdate;
    public boolean shouldUpdate;

    public GameUpdater(String latestVersion, String mainGameUrl) {
        this.latestVersion = latestVersion;
        this.mainGameUrl = mainGameUrl;
    }

    public void init() {
        this.state = 1;
    }

    private String generateStacktrace(Exception exception) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    protected String getDescriptionForState() {
        switch (this.state) {
            case 1: {
                return "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u0430";
            }
            case 2: {
                return "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u0434\u043b\u044f \u0441\u043a\u0430\u0447\u043a\u0438";
            }
            case 3: {
                return "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043a\u0435\u0448-\u0444\u0430\u0439\u043b\u043e\u0432";
            }
            case 4: {
                return "\u0421\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u043e\u0432";
            }
            case 5: {
                return "\u0418\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u0435 \u0441\u043a\u0430\u0447\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432";
            }
            case 6: {
                return "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0443\u0442\u0435\u0439";
            }
            case 7: {
                return "\u0421\u0432\u043e\u0440\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0435 \u0430\u043f\u043f\u043b\u0435\u0442\u0430";
            }
            case 8: {
                return "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0430\u043f\u043f\u043b\u0435\u0442\u0430";
            }
            case 9: {
                return "\u0421\u0442\u0430\u0440\u0442 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0430\u043f\u043f\u043b\u0435\u0442\u0430";
            }
            case 10: {
                return "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430";
            }
            case 11: {
                return "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f";
            }
        }
        return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435";
    }

    protected void loadJarURLs() throws Exception {
        this.state = 2;
        Properties jars = new Properties();
        try {
            jars.load(new URL("http://www.minecraft-moscow.ru/minecraftdownloadtest/md5s").openStream());
            jars.store(new FileOutputStream(new File(Util.getWorkingDirectory(), "md5s")), "");
        }
        catch (Exception e) {
            jars.load(new FileInputStream(new File(Util.getWorkingDirectory(), "md5s")));
        }
        int jarCount = jars.size() + 1;
        this.urlList = new URL[jarCount];
        this.md5s = new String[jarCount];
        this.relativeUrls = new String[jarCount];
        this.fileSizes = new int[jarCount];
        URL path = new URL("http://www.minecraft-moscow.ru/minecraftdownloadtest/");
        int i = 0;
        for (Map.Entry<Object, Object> entry : jars.entrySet()) {
            String[] split = ((String)entry.getValue()).trim().split(";");
            this.md5s[i] = split[0];
            this.fileSizes[i] = Integer.parseInt(split[1]);
            this.relativeUrls[i] = ((String)entry.getKey()).replace("/", File.separator);
            this.urlList[i++] = new URL(path, ((String)entry.getKey()).substring(1).replace(" ", "%20"));
        }
        String osName = System.getProperty("os.name");
        String nativeJar = null;
        if (osName.startsWith("Win")) {
            nativeJar = "windows_natives.jar";
        } else if (osName.startsWith("Linux")) {
            nativeJar = "linux_natives.jar";
        } else if (osName.startsWith("Mac")) {
            nativeJar = "macosx_natives.jar";
        } else if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
            nativeJar = "solaris_natives.jar";
        } else {
            this.fatalErrorOccured("OS (" + osName + ") \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", null);
        }
        if (nativeJar == null) {
            this.fatalErrorOccured("lwjgl \u0444\u0430\u0439\u043b\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b", null);
        } else {
            this.md5s[i] = "";
            this.relativeUrls[i] = File.separator + "bin" + File.separator + nativeJar;
            this.urlList[i] = new URL(path, nativeJar);
            this.fileSizes[i] = this.urlList[i].openConnection().getContentLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.init();
        this.state = 3;
        this.percentage = 5;
        try {
            this.loadJarURLs();
            File dir = Util.getWorkingDirectory();
            File binDir = new File(dir, "bin");
            if (!binDir.exists()) {
                binDir.mkdirs();
            }
            if (this.latestVersion != null) {
                File versionFile = new File(binDir, "version");
                boolean cacheAvailable = false;
                if (!forceUpdate && versionFile.exists() && (this.latestVersion.equals("-1") || this.latestVersion.equals(this.readVersionFile(versionFile)))) {
                    cacheAvailable = true;
                    this.percentage = 90;
                }
                if (forceUpdate || !cacheAvailable) {
                    this.shouldUpdate = true;
                    if (!forceUpdate && versionFile.exists()) {
                        this.checkShouldUpdate();
                    }
                    if (this.shouldUpdate) {
                        this.writeVersionFile(versionFile, "");
                        String binPath = binDir.getCanonicalPath();
                        String path = dir.getCanonicalPath();
                        this.downloadJars(path);
                        this.extractJars(binPath);
                        this.extractNatives(binPath);
                        if (this.latestVersion != null) {
                            this.percentage = 90;
                            this.writeVersionFile(versionFile, this.latestVersion);
                        }
                    } else {
                        this.percentage = 90;
                    }
                }
            }
            this.updateClassPath(binDir);
            this.state = 10;
        }
        catch (AccessControlException ace) {
            this.fatalErrorOccured(ace.getMessage(), ace);
            this.certificateRefused = true;
        }
        catch (Exception e) {
            this.fatalErrorOccured(e.getMessage(), e);
        }
        finally {
            this.loaderThread = null;
        }
    }

    private void checkShouldUpdate() {
        this.pauseAskUpdate = true;
        while (this.pauseAskUpdate) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected String readVersionFile(File file) throws Exception {
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        String version = dis.readUTF();
        dis.close();
        return version;
    }

    protected void writeVersionFile(File file, String version) throws Exception {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
        dos.writeUTF(version);
        dos.close();
    }

    protected void updateClassPath(File dir) throws Exception {
        String path;
        this.state = 6;
        this.percentage = 95;
        URL[] urls = new URL[this.urlList.length];
        for (int i = 0; i < this.urlList.length; ++i) {
            urls[i] = new File(dir, this.getJarName(this.urlList[i])).toURI().toURL();
        }
        if (classLoader == null) {
            classLoader = new URLClassLoader(urls){

                @Override
                protected PermissionCollection getPermissions(CodeSource codesource) {
                    PermissionCollection perms = null;
                    try {
                        Method method = SecureClassLoader.class.getDeclaredMethod("getPermissions", CodeSource.class);
                        method.setAccessible(true);
                        perms = (PermissionCollection)method.invoke((Object)this.getClass().getClassLoader(), codesource);
                        String host = "www.minecraft-moscow.ru";
                        if (host != null && host.length() > 0) {
                            perms.add(new SocketPermission(host, "connect,accept"));
                        } else {
                            codesource.getLocation().getProtocol().equals("file");
                        }
                        perms.add(new FilePermission("<<ALL FILES>>", "read"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return perms;
                }
            };
        }
        if (!(path = dir.getAbsolutePath()).endsWith(File.separator)) {
            path = path + File.separator;
        }
        this.unloadNatives(path);
        System.setProperty("org.lwjgl.librarypath", path + "natives");
        System.setProperty("net.java.games.input.librarypath", path + "natives");
        natives_loaded = true;
    }

    private void unloadNatives(String nativePath) {
        if (!natives_loaded) {
            return;
        }
        try {
            Field field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
            field.setAccessible(true);
            Vector libs = (Vector)field.get(this.getClass().getClassLoader());
            String path = new File(nativePath).getCanonicalPath();
            for (int i = 0; i < libs.size(); ++i) {
                String s = (String)libs.get(i);
                if (!s.startsWith(path)) continue;
                libs.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Applet createApplet() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> appletClass = classLoader.loadClass("net.minecraft.client.MinecraftApplet");
        return (Applet)appletClass.newInstance();
    }

    protected void downloadJars(String path) throws Exception {
        this.state = 4;
        this.percentage = 10;
        int initialPercentage = 10;
        byte[] buffer = new byte[65536];
        block0: for (int i = 0; i < this.urlList.length; ++i) {
            boolean downloadFile = true;
            while (downloadFile) {
                int bufferSize;
                boolean skip;
                downloadFile = false;
                String currentFile = this.relativeUrls[i];
                String curFilePath = path + currentFile;
                File curFile = new File(curFilePath.replace("/", File.separator));
                File curFileDir = new File(curFile.getParent());
                curFileDir.mkdirs();
                this.state = 11;
                if (curFile.createNewFile()) {
                    skip = false;
                } else if ((long)this.fileSizes[i] != curFile.length()) {
                    skip = false;
                } else {
                    int len;
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    FileInputStream is = new FileInputStream(curFile);
                    byte[] buf = new byte[65535];
                    int checked = 0;
                    while ((len = ((InputStream)is).read(buf)) > 0) {
                        md.update(buf, 0, len);
                        this.subPercentage = (checked += len) * 50 / this.fileSizes[i];
                        this.subtaskMessage = "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430: " + currentFile + " " + this.percentage + "%";
                    }
                    String md5 = new BigInteger(1, md.digest()).toString(16);
                    skip = md5.equals(this.md5s[i]);
                }
                this.percentage = initialPercentage + i * 75 / this.urlList.length;
                if (skip) continue block0;
                URLConnection urlconnection = this.urlList[i].openConnection();
                if (urlconnection instanceof HttpURLConnection) {
                    urlconnection.setRequestProperty("Cache-Control", "no-cache");
                    urlconnection.connect();
                }
                InputStream inputstream = this.getJarInputStream(currentFile, urlconnection);
                FileOutputStream fos = new FileOutputStream(curFile);
                long downloadStartTime = System.currentTimeMillis();
                int downloadedAmount = 0;
                int fileSize = 0;
                String downloadSpeedMessage = "";
                this.state = 4;
                while ((bufferSize = inputstream.read(buffer, 0, buffer.length)) != -1) {
                    fos.write(buffer, 0, bufferSize);
                    this.subPercentage = 50 + (fileSize += bufferSize) * 50 / this.fileSizes[i];
                    this.subtaskMessage = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430: " + currentFile + " " + this.percentage + "%";
                    downloadedAmount += bufferSize;
                    long timeLapse = System.currentTimeMillis() - downloadStartTime;
                    if (timeLapse >= 1000L) {
                        float downloadSpeed = (float)downloadedAmount / (float)timeLapse;
                        downloadSpeed = (float)((int)(downloadSpeed * 100.0f)) / 100.0f;
                        downloadSpeedMessage = " @ " + downloadSpeed + " KB/sec";
                        downloadedAmount = 0;
                        downloadStartTime += 1000L;
                    }
                    this.subtaskMessage = this.subtaskMessage + downloadSpeedMessage;
                }
                inputstream.close();
                fos.close();
            }
        }
    }

    protected InputStream getJarInputStream(String currentFile, final URLConnection urlconnection) throws Exception {
        final InputStream[] is = new InputStream[1];
        for (int j = 0; j < 3 && is[0] == null; ++j) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        is[0] = urlconnection.getInputStream();
                    }
                    catch (IOException localIOException) {
                        localIOException.printStackTrace();
                    }
                }
            };
            t.setName("JarInputStreamThread");
            t.start();
            int iterationCount = 0;
            while (is[0] == null && iterationCount++ < 5) {
                try {
                    t.join(1000L);
                }
                catch (InterruptedException localInterruptedException) {}
            }
            if (is[0] != null) continue;
            try {
                t.interrupt();
                t.join();
                continue;
            }
            catch (InterruptedException localInterruptedException1) {
                // empty catch block
            }
        }
        if (is[0] == null) {
            throw new Exception("Unable to download " + currentFile);
        }
        return is[0];
    }

    protected void extractJars(String path) throws Exception {
        this.state = 5;
    }

    protected void extractNatives(String path) throws Exception {
        JarEntry entry;
        File file;
        File nativeFolder;
        this.state = 5;
        System.out.println(path);
        int initialPercentage = this.percentage;
        String nativeJar = this.getJarName(this.urlList[this.urlList.length - 1]);
        Certificate[] certificate = Launcher.class.getProtectionDomain().getCodeSource().getCertificates();
        if (certificate == null) {
            URL location = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
            JarURLConnection jurl = (JarURLConnection)new URL("jar:" + location.toString() + "!/net/minecraft/Launcher.class").openConnection();
            jurl.setDefaultUseCaches(true);
            try {
                certificate = jurl.getCertificates();
            }
            catch (Exception localException) {
                // empty catch block
            }
        }
        if (!(nativeFolder = new File(path + File.separator + "natives")).exists()) {
            nativeFolder.mkdir();
        }
        if (!(file = new File(path + File.separator + nativeJar)).exists()) {
            return;
        }
        JarFile jarFile = new JarFile(file, true);
        Enumeration<JarEntry> entities = jarFile.entries();
        this.totalSizeExtract = 0;
        while (entities.hasMoreElements()) {
            entry = entities.nextElement();
            if (entry.isDirectory() || entry.getName().indexOf(47) != -1) continue;
            this.totalSizeExtract = (int)((long)this.totalSizeExtract + entry.getSize());
        }
        this.currentSizeExtract = 0;
        entities = jarFile.entries();
        while (entities.hasMoreElements()) {
            int bufferSize;
            File f;
            entry = entities.nextElement();
            if (entry.isDirectory() || entry.getName().indexOf(47) != -1 || (f = new File(path + File.separator + "natives" + File.separator + entry.getName())).exists() && !f.delete()) continue;
            InputStream in = jarFile.getInputStream(jarFile.getEntry(entry.getName()));
            FileOutputStream out = new FileOutputStream(path + File.separator + "natives" + File.separator + entry.getName());
            byte[] buffer = new byte[65536];
            while ((bufferSize = in.read(buffer, 0, buffer.length)) != -1) {
                ((OutputStream)out).write(buffer, 0, bufferSize);
                this.currentSizeExtract += bufferSize;
                this.percentage = initialPercentage + this.currentSizeExtract * 20 / this.totalSizeExtract;
                this.subtaskMessage = "Extracting: " + entry.getName() + " " + this.currentSizeExtract * 100 / this.totalSizeExtract + "%";
            }
            GameUpdater.validateCertificateChain(certificate, entry.getCertificates());
            in.close();
            ((OutputStream)out).close();
        }
        this.subtaskMessage = "";
        jarFile.close();
        File f = new File(path + File.separator + nativeJar);
        f.delete();
    }

    protected static void validateCertificateChain(Certificate[] ownCerts, Certificate[] native_certs) throws Exception {
        if (ownCerts == null) {
            return;
        }
        if (native_certs == null) {
            throw new Exception("Unable to validate certificate chain. Native entry did not have a certificate chain at all");
        }
        if (ownCerts.length != native_certs.length) {
            throw new Exception("Unable to validate certificate chain. Chain differs in length [" + ownCerts.length + " vs " + native_certs.length + "]");
        }
        for (int i = 0; i < ownCerts.length; ++i) {
            if (ownCerts[i].equals(native_certs[i])) continue;
            throw new Exception("Certificate mismatch: " + ownCerts[i] + " != " + native_certs[i]);
        }
    }

    protected String getJarName(URL url) {
        String fileName = url.getFile();
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        if (fileName.endsWith(".pack.lzma")) {
            fileName = fileName.replaceAll(".pack.lzma", "");
        } else if (fileName.endsWith(".pack")) {
            fileName = fileName.replaceAll(".pack", "");
        } else if (fileName.endsWith(".lzma")) {
            fileName = fileName.replaceAll(".lzma", "");
        }
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected String getFileName(URL url) {
        String fileName = url.getFile();
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected void fatalErrorOccured(String error, Exception e) {
        e.printStackTrace();
        this.fatalError = true;
        this.fatalErrorDescription = "Fatal error occured (" + this.state + "): " + error;
        System.out.println(this.fatalErrorDescription);
        System.out.println(this.generateStacktrace(e));
    }

    public boolean canPlayOffline() {
        try {
            String version;
            String path = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return Util.getWorkingDirectory() + File.separator + "bin" + File.separator;
                }
            });
            File dir = new File(path);
            if (!dir.exists()) {
                return false;
            }
            if (!(dir = new File(dir, "version")).exists()) {
                return false;
            }
            if (dir.exists() && (version = this.readVersionFile(dir)) != null && version.length() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    static {
        natives_loaded = false;
        forceUpdate = false;
    }
}

